/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.ccfw.mom;

import com.ibm.hsc.ccfw.mom.PIProvidedObject;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HwmcaObjectProviderImpl;
import com.ibm.hwmca.fw.managed.ManagedObjectProperties;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class PIObjectProvider
extends HwmcaObjectProviderImpl
implements ManagedObjectProperties {
    private static final String TRACE_MASKT = "JMOMOP T";
    private static final String TRACE_MASKF = "JMOMOP F";
    private static final String TRACE_MASKD = "JMOMOP D";
    private ClassId[] supportedClasses;

    protected PIObjectProvider(ClassId[] classIdArray) {
        this.supportedClasses = classIdArray;
        Trace.trace((String)TRACE_MASKT, (Object)("<> PIObjectProvider(" + classIdArray + ")"));
    }

    public Map getProperties(ObjectId objectId, String[] stringArray) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIObjectProvider.getProperties(id=" + objectId + "properties=" + stringArray + ")"));
        HashMap<String, ObjectId> hashMap = new HashMap<String, ObjectId>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Object object = null;
            Trace.trace((String)TRACE_MASKT, (Object)("PIObjectProvider.getProperties(): Handling property = " + string));
            if (string.equals("ObjectId")) {
                object = objectId;
            } else if (string.equals("Persistent") || string.equals("AutoPersist") || string.equals("UpgradeData") || string.equals("Root")) {
                object = Boolean.FALSE;
            } else if (string.equals("Children")) {
                object = new ArrayList();
            } else if (string.equals("TargetId")) {
                object = objectId.getFullClassName();
            } else if (string.equals("Busy") || string.equals("AttentionsExist")) {
                object = Boolean.FALSE;
            } else if (string.equals("Groupable")) {
                object = Boolean.TRUE;
            } else if (string.equals("StatusAcceptable")) {
                Object object2 = this.getProperty(objectId, "Status");
                boolean bl = ((Set)this.getProperty(objectId, "AcceptableStatus")).contains(object2);
                object = new Boolean(bl);
            } else if (string.equals("Attentions")) {
                object = new ArrayList();
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)("PIObjectProvider.getProperties(): Property " + string + " does not exist in object " + objectId));
            }
            hashMap.put(string, (ObjectId)object);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIObjectProvider.getProperties()");
        return hashMap;
    }

    public Object getProperty(ObjectId objectId, String string) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIObjectProvider.getProperty(id=" + objectId + ",property=" + string + ")"));
        Map map = this.getProperties(objectId, new String[]{string});
        if (map != null) {
            map = map.get(string);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIObjectProvider.getProperty()");
        return map;
    }

    public void setProperties(ObjectId objectId, Map map) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIObjectProvider.setProperties(ObjectId=" + objectId + "propertyValues=" + map + ")"));
        PIProvidedObject pIProvidedObject = (PIProvidedObject)this.get(objectId);
        try {
            pIProvidedObject.setProperties(map);
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("PIObjectProvider.setProperties(): A property could not be set in object " + objectId));
            Trace.trace((String)TRACE_MASKF, (Object)exception);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIObjectProvider.setProperties()");
    }

    public void setProperty(ObjectId objectId, String string, Object object) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIObjectProvider.setProperty(id=" + objectId + ",property=" + string + ",value=" + object + ")"));
        HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
        hashMap.put(string, object);
        this.setProperties(objectId, hashMap);
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIObjectProvider.setProperty()");
    }

    public Set getInventoryObjectIds() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> PIObjectProvider.getInventoryObjectIds()");
        return this.getInventoryObjectIds(this.supportedClasses);
    }

    public Set getInventoryObjectIds(ClassId classId) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> PIObjectProvider.getInventoryObjectIds(" + classId + ")"));
        ClassId[] classIdArray = new ClassId[]{classId};
        return this.getInventoryObjectIds(classIdArray);
    }

    public Set getInventory(ClassId classId) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> PIObjectProvider.getInventory(" + classId + ")"));
        ClassId[] classIdArray = new ClassId[]{classId};
        return this.getInventory(classIdArray);
    }
}

